# Build iproute2


# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := iproute2
$(PR)_VERSION ?= 3.15.0

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

export CC:=$(CROSS_COMPILE)gcc
export LD:=$(CROSS_COMPILE)ld
export STRIP:=$(CROSS_COMPILE)strip

TEMPINSTALL := $(CPATH)/install

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

$(PR).done: $(PR).patched $(PR).start
	# This requires host compile
	hostincludes.sh enable
	(cd src && $(MAKE) CROSS=$(CROSS_COMPILE) KERNEL_INCLUDE="$(KERNEL_INCLUDE)" EXTRA_INCLUDE="-I$(CDCS_LIBSTAGE)/include" -j1 )
	hostincludes.sh disable
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)/sbin"
	mkdir -p "$(TEMPINSTALL)/bin"
	# This requires host compile
	hostincludes.sh enable
	(cd src && $(MAKE) -j1 CROSS=$(CROSS_COMPILE) KERNEL_INCLUDE="$(KERNEL_INCLUDE)" \
		DESTDIR="$(TEMPINSTALL)" EXTRA_INCLUDE="-I$(CDCS_LIBSTAGE)/include" install )
	hostincludes.sh disable
	# Default install location changes between releases, but scripts use both /bin/ip and /sbin/ip
	if [ ! -f "$(TEMPINSTALL)/sbin/ip" -a -f "$(TEMPINSTALL)/bin/ip" ]; then \
		ln -s "../bin/ip" "$(TEMPINSTALL)/sbin/ip"; \
	fi
	if [ ! -f "$(TEMPINSTALL)/bin/ip" -a -f "$(TEMPINSTALL)/sbin/ip" ]; then \
		ln -s "../sbin/ip" "$(TEMPINSTALL)/bin/ip"; \
	fi
	$(RDIR)/scripts/scatter_install.sh -D /etc -s $(STRIP) -b "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)"


.PHONY: $(PR).clean $(PR).install
