# Build gmp

# Project name
# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := gmp
$(PR)_VERSION ?= 5.0.2

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)


# Config settings
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#

CONFIG_PRESETS :=
TARGET := $(BUILD_TARGET)
CONFIG_OPTS := --host=$(TARGET) --target=$(TARGET) --build=i386
CONFIG_OPTS += --prefix=/

# Enforce License check
ifneq ($(V_LICENSE),gpl3)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error GPLv3 software is prohibited. V_LICENSE=$(V_LICENSE))
endif
endif

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif


# Temporary install directory
TEMPINSTALL := $(CPATH)/install

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done  )
	touch $@

$(PR).configured: $(PR).patched $(PR).start
	(cd src && $(CONFIG_PRESETS) ./configure $(CONFIG_OPTS) )
	touch $@

$(PR).done: $(PR).configured
	# This requires host compile
	hostincludes.sh enable
	( cd src && $(MAKE) -j1)
	hostincludes.sh disable
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	(cd src && DESTDIR="$(TEMPINSTALL)" $(MAKE) -j1 install )
	scatter_install.sh -s $(TARGET)-strip -l "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)"

.PHONY: $(PR).clean $(PR).install
