#
# gdb build
#

#
# TODO: Test on clean toolchain for library dependencies.
# Make package config to build / install full GDB and
# target config to just build GDB server and PC client.
#

# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.tar.*.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := gdb
$(PR)_VERSION ?= 7.7

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions. gdb internal include
# files clash with some files installed into libstaging and the
# searchpath can be broken if we add CDCS_INCLUDE
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)

# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.
TEMPINSTALL := $(CPATH)/install

# Config settings
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#

CONFIG_PRESETS :=
TARGET := $(BUILD_TARGET)
ifeq ($(MAKECMDGOALS),$(PR).package)
  # Package will get configured to use /usr/local as prefix. Also,
  # we need GDB in standalone configuration.
  CONFIG_OPTS := --host=$(TARGET) --target=$(TARGET) --build=i386
  CONFIG_OPTS += --prefix=/usr/local
else
  # Target install. We configure for gdb server only and compile
  # gdb for host.
  CONFIG_OPTS := --host=i386 --target=$(TARGET) --build=i386
  CONFIG_OPTS += --prefix=/
endif

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif


all:
	@echo "Don't invoke this directly!"

#
# The following rules can most likely be left alone if the
# project is based on GNU autotools. If not, modify as
# needed. Only the $(PR).start, $(PR).done and $(PR).install
# targets are mandatory.
#

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

# Standard autotools configure. Non autotools based projects must do something
# different here.
$(PR).configured: $(PR).patched $(PR).start
	(cd src && $(CONFIG_PRESETS) ./configure $(CONFIG_OPTS) )
	touch $@

# Build the project. For projects with broken internal dependencies, you may
# need to replace -j$(PROCS) with -j1
$(PR).done: $(PR).configured
	# This builds host binaries
	hostincludes.sh enable
	(cd src && $(MAKE) -j$(PROCS) )
	hostincludes.sh disable
	touch $@

# Install into temporary directory first. scatter_install.sh copies everything into
# LIBSTAGING and some select items into the staging directory proper. Call
# 'scatter_install.sh -h' for more information.
$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" install )
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
		-b
	touch $@

# Same as install, but creates package
$(PR).package: $(PR).done
	mkdir -p "$(TEMPINSTALL)"
	(cd src && $(MAKE) -j1 DESTDIR="$(TEMPINSTALL)" install )
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" \
		"$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
		-b --ipk CONTROL
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
