# Build electric fence library


PR := electric-fence
$(PR)_VERSION ?= 2.1.13

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)


CC:=$(CROSS_COMPILE)gcc
AR:=$(CROSS_COMPILE)ar

export CC
export AR

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

$(PR).done: $(PR).patched $(PR).start
	(cd src && $(CONFIG_PRESETS) $(MAKE) libefence.a -j$(PROCS) )
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

$(PR).install: $(PR).done
	mkdir -p $(CDCS_LIB)
	cp src/libefence.a $(CDCS_LIB)/

.PHONY: $(PR).clean $(PR).install $(PR).distclean
