#
# Generic recipe template, can be also used for gnu_libs
#


# Project name, version number and tarball extension. Project name
# must match the name of the *.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.<TREXT>.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := ebtables
$(PR)_VERSION ?= v2.0.10-1

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB)


# Config settings, per platform
#
# CONFIG_PRESETS := shell variables to set before configuring, can be
#	useful in bypassing configure script issues (e.g. ac_cv_linux_vers=2),
#	or overriding optimisation settings (e.g. CFLAGS=-Os)
#
# TARGET := target triplet, e.g. arm-cdcs-linux-gnueabi, linux-mipsel, etc
#
# CONFIG_OPTS := configuration options to use, e.g. --host, --target, --build, etc.
#

CFLAGS+=-Wall -Wunused
TARGET := $(BUILD_TARGET)

ifeq ($(PLATFORM),Arachnid)
	CFLAGS += -D PLATFORM_ARACHNID $(PLATFORM_CFLAGS)
endif

ifeq ($(PLATFORM),Platypus2)
	# This may be a bad idea. Ebtables comes with an incomplete
	# kernel include tree, so we force an internal/external include order
	# instead of using KERNEL_INCLUDES. Also, there is an alignment
	# mismatch between this kernel and its own built-in calculation. Overriding.
	CFLAGS += -I$(CPATH)/src/include -I$(KERNELINC) -DEBT_MIN_ALIGN=4
endif

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM '$(PLATFORM)' is unsupported)
endif
endif

export CC:=$(TARGET)-gcc
export LD:=$(TARGET)-ld
export STRIP:=$(TARGET)-strip

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

# Build the project. For projects with broken dependencies, you may need to
# replace -j$(PROCS) with -j1
$(PR).done: $(PR).patched $(PR).start
	(cd src && $(MAKE) static CFLAGS="$(CFLAGS)" CC=$(CC) -j1 $(KERNEL_INC_OPTION) )
	touch $@

# Manually installing stuff
$(PR).install: $(PR).done
	mkdir -p "$(INSTDIR)"/bin/
	cp src/static "$(INSTDIR)"/bin/ebtables
	$(STRIP) "$(INSTDIR)"/bin/ebtables
	mkdir -p "$(INSTDIR)"/etc
	cp src/ethertypes "$(INSTDIR)"/etc/ethertypes


$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
