#
# diethotplug build
#
# This is a manually created tree from a loose *.c file from the 'Net.

# Project name, version number and tarball extension. Project name
# must match the name of the subdirectory with the recipe.mk file
# The tarball is supposed to be called <PROJNAME>-<VERSIONNUMBER>.tar.*.
# Platforms can override the version number if necessary, using
# a different tarball each.
PR := diethotplug
$(PR)_VERSION ?= 0.0

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

#
# Compiler and linker command line additions
#
export CFLAGS := -Os -I$(CDCS_INCLUDE) -Wall -Wshadow -Wstrict-prototypes -D_GNU_SOURCE
export LDFLAGS := -L$(CDCS_LIB) -pipe -s -Wl,-warn-common

# Temporary install directory. We don't install straight into
# STAGING because we may need to cherry-pick only some files.
# This also allows to treat libraries and executables differently
# and install them in STAGING and LIB_STAGE respectively.
TEMPINSTALL := $(CPATH)/install

TARGET := $(BUILD_TARGET)

# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq ($(PLATFORM),)
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM is not set)
endif
endif


all:
	@echo "Don't invoke this directly!"

#
# The following rules can most likely be left alone if the
# project is based on GNU autotools. If not, modify as
# needed. Only the $(PR).start, $(PR).done and $(PR).install
# targets are mandatory.
#

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

# Unpack tarball. Uses the auto-detect feature of tar V1.20+
$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

# Apply all available patches for this project+version
$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

$(PR).done: $(PR).patched $(PR).start
	(cd src && $(CROSS_COMPILE)gcc $(CFLAGS) $(LDFLAGS) hotplug.c -o hotplug )
	touch $@

$(PR).install: $(PR).done
	mkdir -p "$(TEMPINSTALL)/sbin"
	cp "src/hotplug" "$(TEMPINSTALL)/sbin/"
	scatter_install.sh -s $(TARGET)-strip "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)" \
		-b -l
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
