#
# Build Busybox. Using BUSYBOX_CONFIG as configuration file,
# override if necessary.
#

PR := busybox
$(PR)_VERSION ?= 1.19.3

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

NBN_PATCHES := 

#
# Busybox uses a kconfig derived configuration and build system. Using
# busybox_$(PLATFORM).conf. This setting can be overriden by the gnu_apps.mk
# file with a variant specific one if necessary.
#
BUSYBOX_CONFIG ?= busybox_$(PLATFORM).conf

ifeq ($(PLATFORM),Arachnid)
else ifeq ($(PLATFORM),Platypus2)
else ifeq ($(PLATFORM),Bovine)
else ifeq ($(PLATFORM),Serpent)
else ifeq ($(PLATFORM),Antelope)
NBN_PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch.nbn)

else
# We allow clean and distclean targets through, even without a valid PLATFORM
ifeq (,$(filter $(PR).clean $(PR).distclean,$(MAKECMDGOALS)))
$(error PLATFORM '$(PLATFORM)' is unsupported)
endif
endif

# Temporary install directory (must match prefix entry in Busybox config files)
TEMPINSTALL := $(CPATH)/install

all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done  )
	(cd src && for i in $(NBN_PATCHES); do patch -p1 <$$i; done  )
	touch $@

# Kconfig derived configure
$(PR).configured: $(PR).patched $(PR).start
	# We replace the cross-compiler prefix with the build-system provided one
	sed 's/^\(CONFIG_CROSS_COMPILER_PREFIX=\).*/\1"$(BUILD_TARGET)"/' "$(BUSYBOX_CONFIG)" >src/.config
	# Busybox requires host compile
	hostincludes.sh enable
	(cd src && $(MAKE) -j1 oldconfig )
	hostincludes.sh disable
	touch $@

$(PR).done: $(PR).configured
	# This requires host compile
	hostincludes.sh enable
	( cd src && $(MAKE) -j$(PROCS) )
	hostincludes.sh disable
	touch $@

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

$(PR).install: $(PR).done
	# This requires host compile
	hostincludes.sh enable
	(cd src && $(MAKE) -j1 install)
	hostincludes.sh disable
	scatter_install.sh -s $(CROSS_COMPILE)strip -b "$(TEMPINSTALL)" "$(INSTDIR)" "$(CDCS_LIBSTAGE)"
	# Additional links which scatter_install doesn't find
	cp -d "$(TEMPINSTALL)"/* "$(INSTDIR)/" 2>/dev/null || true

.PHONY: $(PR).clean $(PR).install
