# Build bind

# Project name
PR := bind
$(PR)_VERSION ?= 9.9.5

# $(PWD) does not do the right thing for recursive makefiles
CPATH := $(shell /bin/pwd)

VER := $(PR)-$($(PR)_VERSION)
ARCHIVE := $(wildcard $(VER).tar.*)
PATCHES := $(wildcard $(CPATH)/patches/$(VER)/*.patch)

# Config settings

export CFLAGS  := -Os -I$(CDCS_INCLUDE)
export LDFLAGS := -L$(CDCS_LIB) -lncurses 

CONFIG_PRESETS := BUILD_CC=gcc CFLAGS='$(CFLAGS)' LDFLAGS='$(LDFLAGS)'
CONFIG_OPTS := --prefix=/usr --host=$(BUILD_TARGET) --build=i386 --enable-epoll \
	--with-gost=no --with-randomdev=/dev/random --with-libxml2=no --disable-threads \
	--disable-isc-spnego --disable-chroot --disable-linux-caps --with-ecdsa=no --with-atf=no

ifeq ($(ARCH),mips)
# The Platypus toolchain appears to default to MIPS1. We're not in the
# eighties any more. Oh, and this also allows for compiling some inline assembler in atomic.h.
CFLAGS += -march=mips32
endif

CONFIG_OPTS += --disable-chroot --disable-linux-caps --enable-ipv6
CONFIG_OPTS += --with-openssl=$(CDCS_LIBSTAGE)

STRIP:=$(CROSS_COMPILE)strip


all:
	@echo "Don't invoke this directly!"

# Dummy target used for dependency tracking. Make sure that
# it is being referenced by the first stage of this project
# which needs the dependencies in place. Typically, this is
# the configure step.
$(PR).start:
	touch $@

$(PR).unpacked: $(ARCHIVE)
	tar -xf $<
	mv $(VER) src
	touch $@

$(PR).patched: $(PR).unpacked
	(cd src && for i in $(PATCHES); do patch -p1 <$$i; done )
	touch $@

$(PR).configured: $(PR).patched $(PR).start
	(cd src && $(CONFIG_PRESETS) ./configure $(CONFIG_OPTS) )
	touch $@

# This has been forced to -j1 because after changing the libcoap-openssl dep
# the bind build failed (on some products) with:
# arm-ntc-linux-gnueabi-gcc: error: unix/os.o: No such file or directory
# This seems to be an error in bind's build system and will be revisited later.
$(PR).done: $(PR).configured
	# This compiles lib/dns/gen with hostcc
	hostincludes.sh enable
	( cd src && $(MAKE) CFLAGS='$(CFLAGS)' LDFLAGS='$(LDFLAGS)' -j1 )
	hostincludes.sh disable
	touch $@

$(PR).install: $(PR).done
	# install nsupdate only
	install -m 0755 -d "$(INSTDIR)/usr/bin/"
	install -m 0755 "src/bin/nsupdate/nsupdate" "$(INSTDIR)/usr/bin/nsupdate"
	$(STRIP) "$(INSTDIR)/usr/bin/nsupdate"

$(PR).clean: #convertV2
	-(cd src && $(MAKE) -j1 clean; )
	rm -f $(PR).done

$(PR).distclean: #convertV2
	rm -fr src install
	rm -f $(PR).start $(PR).unpacked $(PR).patched $(PR).configured
	rm -f $(PR).done $(PR).install $(PR).package

.PHONY: $(PR).clean $(PR).install
