/*
 * Configuration for NetcommWireless Eagle board
 *
 * Iwo Mergler <Iwo.Mergler@netcommwireless.com>
 *
 * Based on m28evk.h:
 * Copyright (C) 2011 Marek Vasut <marek.vasut@gmail.com>
 * on behalf of DENX Software Engineering GmbH
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 */
#ifndef __NETCOMM_EAGLE_CONFIG_H
#define __NETCOMM_EAGLE_CONFIG_H

#include <asm/arch/regs-base.h>
#include <cdcs_variant.h>

/*
 * SoC configurations
 */
#define CONFIG_MX28				/* i.MX28 SoC */
#define CONFIG_MXS_GPIO			/* GPIO control */
#define CONFIG_SYS_HZ		1000		/* Ticks per second */

#define CONFIG_MACH_TYPE	MACH_TYPE_MX28EVK

#define CONFIG_SYS_NO_FLASH
#define CONFIG_SYS_ICACHE_OFF
#define CONFIG_SYS_DCACHE_OFF
#define CONFIG_BOARD_EARLY_INIT_F
#define CONFIG_ARCH_MISC_INIT

#ifdef V_BATTERY_y
#define CONFIG_UNIFIED_POWER_INIT_PATH
#define CONFIG_POWER_STATE_MACHINE
#else
/* Never use the 5V DC supply, always run from BATT (which is not a battery) */
#define CONFIG_NO_VDD5V
#endif

/*
 * SPL
 */
#define CONFIG_SPL
#define CONFIG_SPL_NO_CPU_SUPPORT_CODE
#define CONFIG_SPL_START_S_PATH	"arch/arm/cpu/arm926ejs/mx28"
#define CONFIG_SPL_LDSCRIPT	"arch/arm/cpu/arm926ejs/mx28/u-boot-spl.lds"
#define CONFIG_SPL_LIBCOMMON_SUPPORT
#define CONFIG_SPL_LIBGENERIC_SUPPORT
#define CONFIG_SPL_GPIO_SUPPORT

/*
 * Additional compiled-in env variables. The board_extra_env()
 * function lives in the board/falcon.c) and is called from common/main.c.
 */
#define CONFIG_BOARD_EXTRA_ENV 1
#ifndef __ASSEMBLY__
void board_extra_env(void);
#endif

/*
 * U-Boot Commands
 */
#include <config_cmd_default.h>

#define CONFIG_DISPLAY_CPUINFO

#define CONFIG_CMD_CACHE
#define CONFIG_CMD_DATE
#define CONFIG_CMD_DHCP
#define CONFIG_CMD_GPIO
#define CONFIG_CMD_MII
#define CONFIG_CMD_NET
#define CONFIG_CMD_NFS
#define CONFIG_CMD_PING
#define CONFIG_CMD_NAND
#define CONFIG_CMD_I2C

#define CONFIG_CMD_FCB /* NAND FCB commands, Freescale specific */

#undef  CONFIG_CMD_GPIO /* We are using the platform GPIO implementation */

/*
 * Memory configurations.
 */
#define KB *1024
#define MB KB*1024
#define GB MB*1024

#define CONFIG_NR_DRAM_BANKS		1		/* 1 bank of DRAM */
#define PHYS_SDRAM_1			0x40000000	/* Base address */
#define PHYS_SDRAM_1_SIZE		(256 MB)          /* Max. size */

#define CONFIG_SYS_SDRAM_BASE		PHYS_SDRAM_1

/* Initial SP is used by SPL too - place in SRAM. */
#define CONFIG_SYS_INIT_RAM_ADDR	0x00000000
#define CONFIG_SYS_INIT_RAM_SIZE	(128 * 1024)

#define CONFIG_SYS_INIT_SP_OFFSET \
	(CONFIG_SYS_INIT_RAM_SIZE - GENERATED_GBL_DATA_SIZE)
#define CONFIG_SYS_INIT_SP_ADDR \
	(CONFIG_SYS_INIT_RAM_ADDR + CONFIG_SYS_INIT_SP_OFFSET)

#define CONFIG_SYS_MALLOC_LEN		(4 MB)

#define CONFIG_SYS_MEMTEST_START	CONFIG_SYS_SDRAM_BASE	/* Memtest start adr */
#define CONFIG_SYS_MEMTEST_END		(4 MB)

/* This is used for linker script too and that doesn't have a preprocessor,
 * so we can't use macros. This address is hardcoded in a few places. */
#define CONFIG_SYS_TEXT_BASE		0x40000100 /* (CONFIG_SYS_SDRAM_BASE) */

/*
 * U-Boot general configurations
 */
#define CONFIG_SYS_LONGHELP
#define CONFIG_SYS_PROMPT	"U-Boot > "
#define CONFIG_SYS_CBSIZE	1024		/* Console I/O buffer size */
#define CONFIG_SYS_PBSIZE	\
	(CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)
						/* Print buffer size */
#define CONFIG_SYS_MAXARGS	32		/* Max number of command args */
#define CONFIG_SYS_BARGSIZE	CONFIG_SYS_CBSIZE
						/* Boot argument buffer size */
#define CONFIG_VERSION_VARIABLE	/* U-BOOT version */
#define CONFIG_AUTO_COMPLETE		/* Command auto complete */
#define CONFIG_CMDLINE_EDITING		/* Command history etc */
#define CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2	" # "
#define CONFIG_CMD_MISC

/*
 * Dynamic partitions
 */

#define CONFIG_MTD_DEVICE 1
#define CONFIG_MTD_PARTITIONS 1

#define CONFIG_CMD_MTDPARTS	/* Partition support */
#define CONFIG_CMD_MTDPARTS_SHOW_NET_SIZES
#define CONFIG_CMD_MTDPARTS_SPREAD

#define CONFIG_NAND_DYNPART 1
#define CONFIG_DYNPART_SIZE  { V_PARTITIONS }
#define CONFIG_DYNPART_NAMES { "boot", "rkern", "rfs", "kernel", "root", "usr", "opt", NULL }
#define MTDIDS_DEFAULT "nand0=gpmi-nand"
#undef  MTDPARTS_DEFAULT
#define CFG_NAND_DYNPART_MTD_KERNEL_NAME "gpmi-nand"

/*
 * Debug port Serial Driver
 */
#if 0
	/* Debug UART */
	#define CONFIG_PL011_SERIAL
	#define CONFIG_PL011_CLOCK		24000000
	#define CONFIG_PL01x_PORTS		{ (void *)MXS_UARTDBG_BASE }
	#define CONFIG_CONS_INDEX		0
	#define CONFIG_BAUDRATE			115200	/* Default baud rate */
#endif

/* Freescale App UART */
#define CONFIG_FREESCALE_APP_UART
#define CONFIG_FREESCALE_UART_BASE  MXS_UARTAPP3_BASE
#define CONFIG_FREESCALE_UART_CLOCK 24000000
#define CONFIG_BAUDRATE 115200
#define CONFIG_SPL_SERIAL_SUPPORT

#ifndef __ASSEMBLY__
	/* Arbitrary UART debug */
	#define DUART_BASE CONFIG_FREESCALE_UART_BASE
	int init_app_uart(void *base, int baudrate);
	void send_app_uart(void *base, unsigned char ch);
	void flush_app_uart(void *base);
	void app_printf(const char *fmt, ...);
	void app_uartbase(unsigned base_addr);
	#define D(fmt, VA...) do { \
		app_uartbase(DUART_BASE); \
		app_printf( "%s:%d: " fmt, __func__, __LINE__, ##VA);\
		flush_app_uart((void*)DUART_BASE);\
	} while(0)
#endif


/*
 * DMA
 */
#define CONFIG_APBH_DMA

/*
 * NAND Driver
 */
#define CONFIG_NAND_MXS
#define CONFIG_SYS_MAX_NAND_DEVICE	1
#define CONFIG_SYS_NAND_BASE		0x60000000
#define CONFIG_SYS_NAND_5_ADDR_CYCLE

/* This enables the bootmode fuse fixup code */
#define CONFIG_BOOTMODE_FUSES

/*
 * Ethernet on SOC (FEC)
 */
#ifdef	CONFIG_CMD_NET
	#define CONFIG_NET_MULTI
	#define CONFIG_ETHPRIME	"FEC0"
	#define CONFIG_FEC_MXC
	#define CONFIG_FEC_MXC_MULTI
	#define CONFIG_MII
	#define CONFIG_DISCOVER_PHY
	#define CONFIG_FEC_XCV_TYPE	RMII
	#define CONFIG_MX28_FEC_MAC_IN_OCOTP
 	#define CONFIG_PHYLIB
	#define CONFIG_ETHTEST          /* Netcomm Ethernet testing infrastructure */
	#define CONFIG_PHY_SMSC

#endif

/*
 * RTC
 */
#ifdef	CONFIG_CMD_DATE
	#define	CONFIG_RTC_MXS
#endif

/*
 * USB
 */
#ifdef	CONFIG_CMD_USB
	#define	CONFIG_USB_EHCI
	#define	CONFIG_USB_EHCI_MXS
	#define	CONFIG_EHCI_MXS_PORT 1
	#define	CONFIG_EHCI_IS_TDI
	#define	CONFIG_USB_STORAGE
#endif

/* I2C */

#define CONFIG_I2C_MXS
#define CONFIG_HARD_I2C
#define CONFIG_SYS_I2C_SPEED	400000

#define CONFIG_I2C_MXS_BASE MXS_I2C1_BASE

#define CONFIG_CMD_EEPROM
#define CONFIG_ENV_EEPROM_IS_ON_I2C
#define CONFIG_SYS_DEF_EEPROM_ADDR 0x50

#define CONFIG_SYS_I2C_EEPROM_ADDR 0x50
#define CONFIG_SYS_I2C_EEPROM_ADDR_LEN 2
#define CONFIG_SYS_EEPROM_PAGE_WRITE_BITS 6

/*
 * Watchdog
 */
#define CONFIG_HW_WATCHDOG
#define CONFIG_MXS_WATCHDOG

	
/* environment */

/* Netcomm high reliability format */
#define CONFIG_ENV_IS_IN_NAND_REL	1
#define CONFIG_ENV_OFFSET		0x100000
#define CONFIG_ENV_SIZE			(4 KB)		/* 2 pages */
#define CONFIG_ENV_PERBLOCK		4		/* 4 envs stored per erase block */
#define CONFIG_ENV_MAX			(1 MB)		/* 4-8 erase blocks */
/* WARNING: Make sure that total number of envs is less than 128 */

#if 0
/* Normal redundant env */
#define CONFIG_ENV_IS_IN_NAND 1
/* #define CONFIG_SYS_REDUNDAND_ENVIRONMENT	1 */
#define CONFIG_ENV_OFFSET		0x180000
#define CONFIG_ENV_SIZE			(4 KB)		/* 2 pages */
#define CONFIG_ENV_OFFSET_REDUND	(CONFIG_ENV_OFFSET + 128 KB) /* 1 erase block */
#endif

#define CONFIG_ENV_OVERWRITE

/*
 * Boot Linux
 */
#define CONFIG_CMDLINE_TAG
#define CONFIG_SETUP_MEMORY_TAGS
#define CONFIG_BOOTDELAY	3
#define CONFIG_BOOTFILE	"uImage"
#define CONFIG_BOOTCOMMAND	"ocotp_env; setenv bootcmd 'run boot'; saveenv; saveenv; boot"
#define CONFIG_LOADADDR	0x42000000
#define CONFIG_SYS_LOAD_ADDR	CONFIG_LOADADDR
#define CONFIG_OF_LIBFDT

/*
 * Default Environment. This environment is used in case of an environment
 * loss. Attempts to boot recovery:
 *	- populate ethaddr, sn, snextra from fuses, then change bootcmd to not do that again.
 *	- Generate dynparts if necessary
 *	- Boot recovery only
 *	- recovery system sees emergency=env and restores whole env from backup.
 *	- In case recovery boot fails, attempt to reflash via TFTP server at default address 192.168.1.33.
 */

#define CONFIG_EXTRA_ENV_SETTINGS \
	"mb=0x40000000\0"\
	"kb=0x42C00000\0"\
	"BS_S=0x050000\0"\
	"RFS_S=0xc00000\0"\
	"KERN_S=0x500000\0"\
	"FS_S=0x2000000\0"\
	"nrkern=tftp $mb uImage_r && nand erase.part rkern && nand write $mb rkern $filesize\0"\
	"nrf=tftp $mb root_r.ubi && nand erase.part rfs && nand write $mb rfs $filesize\0"\
	"nk=run mkargs_n; tftp $kb compiled_kernel; bootm $kb\0"\
	"checkdyn=if test X$mtdparts = X; then dynpart; fi\0"\
	"bootflash=nand erase 80000 50000; fcb write; nand write 40200000 80000 50000\0"\
	"button=gpior $V_RECBUTTON; r=$?; if test $r != $V_POLBUTTON; then setenv emergency button ; saveenv; fi\0"\
	"bargs_c=console=ttyAPP3,115200n8\0"\
	"bargs_r=root=ubi0:rootfs rw ubi.mtd=rfs,2048 rootfstype=ubifs\0"\
	"bargs_m=root=ubi0:rootfs rw ubi.mtd=root,2048 rootfstype=ubifs\0"\
	"nfsroot=/exports/netc/mnt\0"\
	"bargs_n=root=/dev/nfs nfsroot=$serverip:$nfsroot,nolock,rsize=1024,wsize=1024 rw ip=$ipaddr\0"\
	"mkargs_r=setenv bootargs $bargs_c $bargs_r $mtdparts\0"\
	"mkargs_m=setenv bootargs $bargs_c $bargs_m $mtdparts\0"\
	"mkargs_n=setenv bootargs $bargs_c $bargs_n $mtdparts\0"\
	"bootsel=if test X$emergency = X ; then run main_sequence; else run recovery_sequence; fi\0"\
	"boot_recovery=run mkargs_r; setenv kpart rkern; echo 'Booting recovery system'; run bkern;\0"\
	"boot_main=run mkargs_m; setenv kpart kernel; echo 'Booting main system'; run bkern;\0"\
	"bkern=echo \"Kernel args: $bootargs\"; nand read $kb $kpart $KERN_S; bootm $kb;\0"\
	"recovery_sequence=run boot_recovery; setenv emergency kernel_rec ; saveenv; run boot_main;\0"\
	"main_sequence=run boot_main; setenv emergency kernel_crc ; saveenv; run boot_recovery;\0"\
	"tftp_flash=run nrf; run nrkern; setenv emergency tftp ; saveenv; run recovery_sequence;\0"\
	"boot=run button; run bootsel; run tftp_flash\0"\
	"emergency=env\0"\
	"ethact=FEC0\0"\
	"ipaddr=192.168.1.1\0"\
	"serverip=192.168.1.33\0"\
	"netretry=once\0"\
	"boot=run checkdyn; saveenv; run boot_recovery; run nrf && run nrkern && boot\0"\


/* TODO: fix the default boot in case there is no recovery env backup */

#endif /* __NETCOMM_EAGLE_CONFIG_H */
