#include <common.h>
#include <exports.h>

#include "gpio.h"

#define MAX_GPIOS_LENGTH 256
/* parse instring for GPIO bank:pin and configure as input in array gpio_presets */
void gpio_buttons_init(struct gpio_preset *gpio_presets, const char *instring)
{
	char *token;
	char *sbank;
	long bank, pin;
	char *endptr;

	char string[MAX_GPIOS_LENGTH];
	char *pstring = &string[0];
	int len;

	struct gpio_preset *p;

	len = strnlen(instring, MAX_GPIOS_LENGTH);
	if ((len == MAX_GPIOS_LENGTH) || (len == 0)) {
		return;
        }

	strcpy(string,instring);

	while ((token = strsep(&pstring, " ")) != NULL){
		if ((sbank = strsep(&token, ":")) != NULL){
			bank = simple_strtol(sbank, &endptr, 10);
			if (*endptr == '\0'){
				/* maximum 0-4 GPIO banks */
				if ((bank>=0) && (bank<=4)){
					pin = simple_strtol(token, &endptr, 10);
					if (*endptr == '\0'){
						/* maximum 32 pins per bank */
						if ((pin>=0) && (pin<=31)){
							p = gpio_presets;
							while (p->pin != NOPIN) {
								if (p->pin == PIN(bank,pin)){
									p->v.muxmode = IN;
									p->v.volt = 1;
									p->v.amp = 0;
									p->v.pullup = 0;
									p->v.dout = 0;
								}
								p++;
							}
						}
					}
				}
			}
		}
	}
}


