/*
 * Freescale i.MX28 MX28 specific functions
 *
 * Copyright (C) 2011 Marek Vasut <marek.vasut@gmail.com>
 * on behalf of DENX Software Engineering GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __MX28_H__
#define __MX28_H__

int mx28_reset_block(struct mx28_register_32 *reg);
int mx28_wait_mask_set(struct mx28_register_32 *reg,
		       uint32_t mask,
		       int timeout);
int mx28_wait_mask_clr(struct mx28_register_32 *reg,
		       uint32_t mask,
		       int timeout);

int mxsmmc_initialize(bd_t *bis, int id, int (*wp)(int));

#ifdef CONFIG_SPL_BUILD
#include <asm/arch/iomux-mx28.h>
void mx28_common_spl_init(const iomux_cfg_t *iomux_setup,
			const unsigned int iomux_size);
void mx28_dump_fuses(void);
#ifdef CONFIG_SPL_FUSEDATA_ADDR
void mx28_blow_fuses(void);
#endif /* CONFIG_SPL_FUSEDATA_ADDR */
#endif /* CONFIG_SPL_BUILD */

struct mx28_pair {
	uint8_t	boot_pads;
	uint8_t boot_mask;
	const char *mode;
};

static const struct mx28_pair mx28_boot_modes[] = {
	{ 0x00, 0x0f, "USB #0" },
	{ 0x01, 0x1f, "I2C #0, master, 3V3" },
	{ 0x11, 0x1f, "I2C #0, master, 1V8" },
	{ 0x02, 0x1f, "SSP SPI #2, master, 3V3 NOR" },
	{ 0x12, 0x1f, "SSP SPI #2, master, 1V8 NOR" },
	{ 0x03, 0x1f, "SSP SPI #3, master, 3V3 NOR" },
	{ 0x13, 0x1f, "SSP SPI #3, master, 1V8 NOR" },
	{ 0x04, 0x1f, "NAND, 3V3" },
	{ 0x14, 0x1f, "NAND, 1V8" },
	{ 0x08, 0x1f, "SSP SPI #3, master, 3V3 EEPROM" },
	{ 0x18, 0x1f, "SSP SPI #3, master, 1V8 EEPROM" },
	{ 0x09, 0x1f, "SSP SD/MMC #0, 3V3" },
	{ 0x19, 0x1f, "SSP SD/MMC #0, 1V8" },
	{ 0x0a, 0x1f, "SSP SD/MMC #1, 3V3" },
	{ 0x1a, 0x1f, "SSP SD/MMC #1, 1V8" },
	{ 0x00, 0x00, "Reserved/Unknown/Wrong" },
};

struct mx28_spl_data {
	uint8_t		boot_mode_idx;
	uint32_t	mem_dram_size;
};

int mx28_dram_init(void);

#ifdef CONFIG_POWER_STATE_MACHINE
typedef enum {
	OFF,
	PSWITCH_MID,
	BOOTING
} power_state_machine_t;
extern power_state_machine_t state_machine;
/* power status structure */
struct power_status{
	int vdd5v_detected;
	int vdd5v_charger;
	int batt_detected;
	int batt_ok_to_boot;
};
int mx28_is_batt_temp_ok_for_charging(void);
void mx28_powerdown_the_chip(void);
void mx28_check_power_state(struct power_status *state);
int mx28_pswitch_event(void);
int mx28_is_vdd5v_detected(void);
int mx28_is_charger_on(void);
void mx28_turn_off_charger(void);
void mx28_turn_on_charger(int stop_ilimit, int charge_ilimit);
void mx28_check_charge_ilimit_stop(void);
int mx28_is_batt_volt_below_high_thresh(void);
void mx28_disable_pswitch_irq(void);
void mx28_disable_usb_plugin_detect(void);
void mx28_hand_over_battery(void);
#endif

#endif	/* __MX28_H__ */
